/*=============================================================================
	OpenGLFuncs.h: OpenGL function-declaration macros.

	Copyright 2002 Epic Games, Inc. All Rights Reserved.

	Revision history:
		* Created by Daniel Vogel

=============================================================================*/

/*-----------------------------------------------------------------------------
	Standard OpenGL functions.
-----------------------------------------------------------------------------*/

GL_EXT(_GL)

// OpenGL 1.1
GL_PROC(_GL,void,glAccum,(GLenum,GLfloat))
GL_PROC(_GL,void,glAlphaFunc,(GLenum,GLclampf))
GL_PROC(_GL,GLboolean,glAreTexturesResident,(GLsizei,const GLuint*,GLboolean*))
GL_PROC(_GL,void,glArrayElement,(GLint))
GL_PROC(_GL,void,glBegin,(GLenum))
GL_PROC(_GL,void,glBindTexture,(GLenum,GLuint))
GL_PROC(_GL,void,glBitmap,(GLsizei,GLsizei,GLfloat,GLfloat,GLfloat,GLfloat,const GLubyte*))
GL_PROC(_GL,void,glBlendFunc,(GLenum,GLenum))
GL_PROC(_GL,void,glCallList,(GLuint))
GL_PROC(_GL,void,glCallLists,(GLsizei,GLenum,const GLvoid*))
GL_PROC(_GL,void,glClear,(GLbitfield))
GL_PROC(_GL,void,glClearAccum,(GLfloat,GLfloat,GLfloat,GLfloat))
GL_PROC(_GL,void,glClearColor,(GLclampf,GLclampf,GLclampf,GLclampf))
GL_PROC(_GL,void,glClearDepth,(GLclampd))
GL_PROC(_GL,void,glClearIndex,(GLfloat))
GL_PROC(_GL,void,glClearStencil,(GLint))
GL_PROC(_GL,void,glClipPlane,(GLenum,const GLdouble*))
GL_PROC(_GL,void,glColor3b,(GLbyte,GLbyte,GLbyte))
GL_PROC(_GL,void,glColor3bv,(const GLbyte*))
GL_PROC(_GL,void,glColor3d,(GLdouble,GLdouble,GLdouble))
GL_PROC(_GL,void,glColor3dv,(const GLdouble*))
GL_PROC(_GL,void,glColor3f,(GLfloat,GLfloat,GLfloat))
GL_PROC(_GL,void,glColor3fv,(const GLfloat*))
GL_PROC(_GL,void,glColor3i,(GLint,GLint,GLint))
GL_PROC(_GL,void,glColor3iv,(const GLint*))
GL_PROC(_GL,void,glColor3s,(GLshort,GLshort,GLshort))
GL_PROC(_GL,void,glColor3sv,(const GLshort*))
GL_PROC(_GL,void,glColor3ub,(GLubyte,GLubyte,GLubyte))
GL_PROC(_GL,void,glColor3ubv,(const GLubyte*))
GL_PROC(_GL,void,glColor3ui,(GLuint,GLuint,GLuint))
GL_PROC(_GL,void,glColor3uiv,(const GLuint*))
GL_PROC(_GL,void,glColor3us,(GLushort,GLushort,GLushort))
GL_PROC(_GL,void,glColor3usv,(const GLushort*))
GL_PROC(_GL,void,glColor4b,(GLbyte,GLbyte,GLbyte,GLbyte))
GL_PROC(_GL,void,glColor4bv,(const GLbyte*))
GL_PROC(_GL,void,glColor4d,(GLdouble,GLdouble,GLdouble,GLdouble))
GL_PROC(_GL,void,glColor4dv,(const GLdouble*))
GL_PROC(_GL,void,glColor4f,(GLfloat,GLfloat,GLfloat,GLfloat))
GL_PROC(_GL,void,glColor4fv,(const GLfloat*))
GL_PROC(_GL,void,glColor4i,(GLint,GLint,GLint,GLint))
GL_PROC(_GL,void,glColor4iv,(const GLint*))
GL_PROC(_GL,void,glColor4s,(GLshort,GLshort,GLshort,GLshort))
GL_PROC(_GL,void,glColor4sv,(const GLshort*))
GL_PROC(_GL,void,glColor4ub,(GLubyte red, GLubyte green, GLubyte blue, GLubyte alpha))
GL_PROC(_GL,void,glColor4ubv,(const GLubyte *v))
GL_PROC(_GL,void,glColor4ui,(GLuint red, GLuint green, GLuint blue, GLuint alpha))
GL_PROC(_GL,void,glColor4uiv,(const GLuint *v))
GL_PROC(_GL,void,glColor4us,(GLushort red, GLushort green, GLushort blue, GLushort alpha))
GL_PROC(_GL,void,glColor4usv,(const GLushort *v))
GL_PROC(_GL,void,glColorMask,(GLboolean red, GLboolean green, GLboolean blue, GLboolean alpha))
GL_PROC(_GL,void,glColorMaterial,(GLenum face, GLenum mode))
GL_PROC(_GL,void,glColorPointer,(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer))
GL_PROC(_GL,void,glCopyPixels,(GLint x, GLint y, GLsizei width, GLsizei height, GLenum type))
GL_PROC(_GL,void,glCopyTexImage1D,(GLenum target, GLint level, GLenum internalFormat, GLint x, GLint y, GLsizei width, GLint border))
GL_PROC(_GL,void,glCopyTexImage2D,(GLenum target, GLint level, GLenum internalFormat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border))
GL_PROC(_GL,void,glCopyTexSubImage1D,(GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width))
GL_PROC(_GL,void,glCopyTexSubImage2D,(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height))
GL_PROC(_GL,void,glCullFace,(GLenum mode))
GL_PROC(_GL,void,glDeleteLists,(GLuint list, GLsizei range))
GL_PROC(_GL,void,glDeleteTextures,(GLsizei n, const GLuint *textures))
GL_PROC(_GL,void,glDepthFunc,(GLenum func))
GL_PROC(_GL,void,glDepthMask,(GLboolean flag))
GL_PROC(_GL,void,glDepthRange,(GLclampd zNear, GLclampd zFar))
GL_PROC(_GL,void,glDisable,(GLenum cap))
GL_PROC(_GL,void,glDisableClientState,(GLenum array))
GL_PROC(_GL,void,glDrawArrays,(GLenum mode, GLint first, GLsizei count))
GL_PROC(_GL,void,glDrawBuffer,(GLenum mode))
GL_PROC(_GL,void,glDrawElements,(GLenum mode, GLsizei count, GLenum type, const GLvoid *indices))
GL_PROC(_GL,void,glDrawPixels,(GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels))
GL_PROC(_GL,void,glEdgeFlag,(GLboolean flag))
GL_PROC(_GL,void,glEdgeFlagPointer,(GLsizei stride, const GLvoid *pointer))
GL_PROC(_GL,void,glEdgeFlagv,(const GLboolean *flag))
GL_PROC(_GL,void,glEnable,(GLenum cap))
GL_PROC(_GL,void,glEnableClientState,(GLenum array))
GL_PROC(_GL,void,glEnd,(void))
GL_PROC(_GL,void,glEndList,(void))
GL_PROC(_GL,void,glEvalCoord1d,(GLdouble u))
GL_PROC(_GL,void,glEvalCoord1dv,(const GLdouble *u))
GL_PROC(_GL,void,glEvalCoord1f,(GLfloat u))
GL_PROC(_GL,void,glEvalCoord1fv,(const GLfloat *u))
GL_PROC(_GL,void,glEvalCoord2d,(GLdouble u, GLdouble v))
GL_PROC(_GL,void,glEvalCoord2dv,(const GLdouble *u))
GL_PROC(_GL,void,glEvalCoord2f,(GLfloat u, GLfloat v))
GL_PROC(_GL,void,glEvalCoord2fv,(const GLfloat *u))
GL_PROC(_GL,void,glEvalMesh1,(GLenum mode, GLint i1, GLint i2))
GL_PROC(_GL,void,glEvalMesh2,(GLenum mode, GLint i1, GLint i2, GLint j1, GLint j2))
GL_PROC(_GL,void,glEvalPoint1,(GLint i))
GL_PROC(_GL,void,glEvalPoint2,(GLint i, GLint j))
GL_PROC(_GL,void,glFeedbackBuffer,(GLsizei size, GLenum type, GLfloat *buffer))
GL_PROC(_GL,void,glFinish,(void))
GL_PROC(_GL,void,glFlush,(void))
GL_PROC(_GL,void,glFogf,(GLenum pname, GLfloat param))
GL_PROC(_GL,void,glFogfv,(GLenum pname, const GLfloat *params))
GL_PROC(_GL,void,glFogi,(GLenum pname, GLint param))
GL_PROC(_GL,void,glFogiv,(GLenum pname, const GLint *params))
GL_PROC(_GL,void,glFrontFace,(GLenum mode))
GL_PROC(_GL,void,glFrustum,(GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar))
GL_PROC(_GL,GLuint,glGenLists,(GLsizei range))
GL_PROC(_GL,void,glGenTextures,(GLsizei n, GLuint *textures))
GL_PROC(_GL,void,glGetBooleanv,(GLenum pname, GLboolean *params))
GL_PROC(_GL,void,glGetClipPlane,(GLenum plane, GLdouble *equation))
GL_PROC(_GL,void,glGetDoublev,(GLenum pname, GLdouble *params))
GL_PROC(_GL,GLenum,glGetError,(void))
GL_PROC(_GL,void,glGetFloatv,(GLenum pname, GLfloat *params))
GL_PROC(_GL,void,glGetIntegerv,(GLenum pname, GLint *params))
GL_PROC(_GL,void,glGetLightfv,(GLenum light, GLenum pname, GLfloat *params))
GL_PROC(_GL,void,glGetLightiv,(GLenum light, GLenum pname, GLint *params))
GL_PROC(_GL,void,glGetMapdv,(GLenum target, GLenum query, GLdouble *v))
GL_PROC(_GL,void,glGetMapfv,(GLenum target, GLenum query, GLfloat *v))
GL_PROC(_GL,void,glGetMapiv,(GLenum target, GLenum query, GLint *v))
GL_PROC(_GL,void,glGetMaterialfv,(GLenum face, GLenum pname, GLfloat *params))
GL_PROC(_GL,void,glGetMaterialiv,(GLenum face, GLenum pname, GLint *params))
GL_PROC(_GL,void,glGetPixelMapfv,(GLenum map, GLfloat *values))
GL_PROC(_GL,void,glGetPixelMapuiv,(GLenum map, GLuint *values))
GL_PROC(_GL,void,glGetPixelMapusv,(GLenum map, GLushort *values))
GL_PROC(_GL,void,glGetPointerv,(GLenum pname, GLvoid* *params))
GL_PROC(_GL,void,glGetPolygonStipple,(GLubyte *mask))
GL_PROC(_GL,const GLubyte *,glGetString,(GLenum name))
GL_PROC(_GL,void,glGetTexEnvfv,(GLenum target, GLenum pname, GLfloat *params))
GL_PROC(_GL,void,glGetTexEnviv,(GLenum target, GLenum pname, GLint *params))
GL_PROC(_GL,void,glGetTexGendv,(GLenum coord, GLenum pname, GLdouble *params))
GL_PROC(_GL,void,glGetTexGenfv,(GLenum coord, GLenum pname, GLfloat *params))
GL_PROC(_GL,void,glGetTexGeniv,(GLenum coord, GLenum pname, GLint *params))
GL_PROC(_GL,void,glGetTexImage,(GLenum target, GLint level, GLenum format, GLenum type, GLvoid *pixels))
GL_PROC(_GL,void,glGetTexLevelParameterfv,(GLenum target, GLint level, GLenum pname, GLfloat *params))
GL_PROC(_GL,void,glGetTexLevelParameteriv,(GLenum target, GLint level, GLenum pname, GLint *params))
GL_PROC(_GL,void,glGetTexParameterfv,(GLenum target, GLenum pname, GLfloat *params))
GL_PROC(_GL,void,glGetTexParameteriv,(GLenum target, GLenum pname, GLint *params))
GL_PROC(_GL,void,glHint,(GLenum target, GLenum mode))
GL_PROC(_GL,void,glIndexMask,(GLuint mask))
GL_PROC(_GL,void,glIndexPointer,(GLenum type, GLsizei stride, const GLvoid *pointer))
GL_PROC(_GL,void,glIndexd,(GLdouble c))
GL_PROC(_GL,void,glIndexdv,(const GLdouble *c))
GL_PROC(_GL,void,glIndexf,(GLfloat c))
GL_PROC(_GL,void,glIndexfv,(const GLfloat *c))
GL_PROC(_GL,void,glIndexi,(GLint c))
GL_PROC(_GL,void,glIndexiv,(const GLint *c))
GL_PROC(_GL,void,glIndexs,(GLshort c))
GL_PROC(_GL,void,glIndexsv,(const GLshort *c))
GL_PROC(_GL,void,glIndexub,(GLubyte c))
GL_PROC(_GL,void,glIndexubv,(const GLubyte *c))
GL_PROC(_GL,void,glInitNames,(void))
GL_PROC(_GL,void,glInterleavedArrays,(GLenum format, GLsizei stride, const GLvoid *pointer))
GL_PROC(_GL,GLboolean,glIsEnabled,(GLenum cap))
GL_PROC(_GL,GLboolean,glIsList,(GLuint list))
GL_PROC(_GL,GLboolean,glIsTexture,(GLuint texture))
GL_PROC(_GL,void,glLightModelf,(GLenum pname, GLfloat param))
GL_PROC(_GL,void,glLightModelfv,(GLenum pname, const GLfloat *params))
GL_PROC(_GL,void,glLightModeli,(GLenum pname, GLint param))
GL_PROC(_GL,void,glLightModeliv,(GLenum pname, const GLint *params))
GL_PROC(_GL,void,glLightf,(GLenum light, GLenum pname, GLfloat param))
GL_PROC(_GL,void,glLightfv,(GLenum light, GLenum pname, const GLfloat *params))
GL_PROC(_GL,void,glLighti,(GLenum light, GLenum pname, GLint param))
GL_PROC(_GL,void,glLightiv,(GLenum light, GLenum pname, const GLint *params))
GL_PROC(_GL,void,glLineStipple,(GLint factor, GLushort pattern))
GL_PROC(_GL,void,glLineWidth,(GLfloat width))
GL_PROC(_GL,void,glListBase,(GLuint base))
GL_PROC(_GL,void,glLoadIdentity,(void))
GL_PROC(_GL,void,glLoadMatrixd,(const GLdouble *m))
GL_PROC(_GL,void,glLoadMatrixf,(const GLfloat *m))
GL_PROC(_GL,void,glLoadName,(GLuint name))
GL_PROC(_GL,void,glLogicOp,(GLenum opcode))
GL_PROC(_GL,void,glMap1d,(GLenum target, GLdouble u1, GLdouble u2, GLint stride, GLint order, const GLdouble *points))
GL_PROC(_GL,void,glMap1f,(GLenum target, GLfloat u1, GLfloat u2, GLint stride, GLint order, const GLfloat *points))
GL_PROC(_GL,void,glMap2d,(GLenum target, GLdouble u1, GLdouble u2, GLint ustride, GLint uorder, GLdouble v1, GLdouble v2, GLint vstride, GLint vorder, const GLdouble *points))
GL_PROC(_GL,void,glMap2f,(GLenum target, GLfloat u1, GLfloat u2, GLint ustride, GLint uorder, GLfloat v1, GLfloat v2, GLint vstride, GLint vorder, const GLfloat *points))
GL_PROC(_GL,void,glMapGrid1d,(GLint un, GLdouble u1, GLdouble u2))
GL_PROC(_GL,void,glMapGrid1f,(GLint un, GLfloat u1, GLfloat u2))
GL_PROC(_GL,void,glMapGrid2d,(GLint un, GLdouble u1, GLdouble u2, GLint vn, GLdouble v1, GLdouble v2))
GL_PROC(_GL,void,glMapGrid2f,(GLint un, GLfloat u1, GLfloat u2, GLint vn, GLfloat v1, GLfloat v2))
GL_PROC(_GL,void,glMaterialf,(GLenum face, GLenum pname, GLfloat param))
GL_PROC(_GL,void,glMaterialfv,(GLenum face, GLenum pname, const GLfloat *params))
GL_PROC(_GL,void,glMateriali,(GLenum face, GLenum pname, GLint param))
GL_PROC(_GL,void,glMaterialiv,(GLenum face, GLenum pname, const GLint *params))
GL_PROC(_GL,void,glMatrixMode,(GLenum mode))
GL_PROC(_GL,void,glMultMatrixd,(const GLdouble *m))
GL_PROC(_GL,void,glMultMatrixf,(const GLfloat *m))
GL_PROC(_GL,void,glNewList,(GLuint list, GLenum mode))
GL_PROC(_GL,void,glNormal3b,(GLbyte nx, GLbyte ny, GLbyte nz))
GL_PROC(_GL,void,glNormal3bv,(const GLbyte *v))
GL_PROC(_GL,void,glNormal3d,(GLdouble nx, GLdouble ny, GLdouble nz))
GL_PROC(_GL,void,glNormal3dv,(const GLdouble *v))
GL_PROC(_GL,void,glNormal3f,(GLfloat nx, GLfloat ny, GLfloat nz))
GL_PROC(_GL,void,glNormal3fv,(const GLfloat *v))
GL_PROC(_GL,void,glNormal3i,(GLint nx, GLint ny, GLint nz))
GL_PROC(_GL,void,glNormal3iv,(const GLint *v))
GL_PROC(_GL,void,glNormal3s,(GLshort nx, GLshort ny, GLshort nz))
GL_PROC(_GL,void,glNormal3sv,(const GLshort *v))
GL_PROC(_GL,void,glNormalPointer,(GLenum type, GLsizei stride, const GLvoid *pointer))
GL_PROC(_GL,void,glOrtho,(GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar))
GL_PROC(_GL,void,glPassThrough,(GLfloat token))
GL_PROC(_GL,void,glPixelMapfv,(GLenum map, GLsizei mapsize, const GLfloat *values))
GL_PROC(_GL,void,glPixelMapuiv,(GLenum map, GLsizei mapsize, const GLuint *values))
GL_PROC(_GL,void,glPixelMapusv,(GLenum map, GLsizei mapsize, const GLushort *values))
GL_PROC(_GL,void,glPixelStoref,(GLenum pname, GLfloat param))
GL_PROC(_GL,void,glPixelStorei,(GLenum pname, GLint param))
GL_PROC(_GL,void,glPixelTransferf,(GLenum pname, GLfloat param))
GL_PROC(_GL,void,glPixelTransferi,(GLenum pname, GLint param))
GL_PROC(_GL,void,glPixelZoom,(GLfloat xfactor, GLfloat yfactor))
GL_PROC(_GL,void,glPointSize,(GLfloat size))
GL_PROC(_GL,void,glPolygonMode,(GLenum face, GLenum mode))
GL_PROC(_GL,void,glPolygonOffset,(GLfloat factor, GLfloat units))
GL_PROC(_GL,void,glPolygonStipple,(const GLubyte *mask))
GL_PROC(_GL,void,glPopAttrib,(void))
GL_PROC(_GL,void,glPopClientAttrib,(void))
GL_PROC(_GL,void,glPopMatrix,(void))
GL_PROC(_GL,void,glPopName,(void))
GL_PROC(_GL,void,glPrioritizeTextures,(GLsizei n, const GLuint *textures, const GLclampf *priorities))
GL_PROC(_GL,void,glPushAttrib,(GLbitfield mask))
GL_PROC(_GL,void,glPushClientAttrib,(GLbitfield mask))
GL_PROC(_GL,void,glPushMatrix,(void))
GL_PROC(_GL,void,glPushName,(GLuint name))
GL_PROC(_GL,void,glRasterPos2d,(GLdouble x, GLdouble y))
GL_PROC(_GL,void,glRasterPos2dv,(const GLdouble *v))
GL_PROC(_GL,void,glRasterPos2f,(GLfloat x, GLfloat y))
GL_PROC(_GL,void,glRasterPos2fv,(const GLfloat *v))
GL_PROC(_GL,void,glRasterPos2i,(GLint x, GLint y))
GL_PROC(_GL,void,glRasterPos2iv,(const GLint *v))
GL_PROC(_GL,void,glRasterPos2s,(GLshort x, GLshort y))
GL_PROC(_GL,void,glRasterPos2sv,(const GLshort *v))
GL_PROC(_GL,void,glRasterPos3d,(GLdouble x, GLdouble y, GLdouble z))
GL_PROC(_GL,void,glRasterPos3dv,(const GLdouble *v))
GL_PROC(_GL,void,glRasterPos3f,(GLfloat x, GLfloat y, GLfloat z))
GL_PROC(_GL,void,glRasterPos3fv,(const GLfloat *v))
GL_PROC(_GL,void,glRasterPos3i,(GLint x, GLint y, GLint z))
GL_PROC(_GL,void,glRasterPos3iv,(const GLint *v))
GL_PROC(_GL,void,glRasterPos3s,(GLshort x, GLshort y, GLshort z))
GL_PROC(_GL,void,glRasterPos3sv,(const GLshort *v))
GL_PROC(_GL,void,glRasterPos4d,(GLdouble x, GLdouble y, GLdouble z, GLdouble w))
GL_PROC(_GL,void,glRasterPos4dv,(const GLdouble *v))
GL_PROC(_GL,void,glRasterPos4f,(GLfloat x, GLfloat y, GLfloat z, GLfloat w))
GL_PROC(_GL,void,glRasterPos4fv,(const GLfloat *v))
GL_PROC(_GL,void,glRasterPos4i,(GLint x, GLint y, GLint z, GLint w))
GL_PROC(_GL,void,glRasterPos4iv,(const GLint *v))
GL_PROC(_GL,void,glRasterPos4s,(GLshort x, GLshort y, GLshort z, GLshort w))
GL_PROC(_GL,void,glRasterPos4sv,(const GLshort *v))
GL_PROC(_GL,void,glReadBuffer,(GLenum mode))
GL_PROC(_GL,void,glReadPixels,(GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLvoid *pixels))
GL_PROC(_GL,void,glRectd,(GLdouble x1, GLdouble y1, GLdouble x2, GLdouble y2))
GL_PROC(_GL,void,glRectdv,(const GLdouble *v1, const GLdouble *v2))
GL_PROC(_GL,void,glRectf,(GLfloat x1, GLfloat y1, GLfloat x2, GLfloat y2))
GL_PROC(_GL,void,glRectfv,(const GLfloat *v1, const GLfloat *v2))
GL_PROC(_GL,void,glRecti,(GLint x1, GLint y1, GLint x2, GLint y2))
GL_PROC(_GL,void,glRectiv,(const GLint *v1, const GLint *v2))
GL_PROC(_GL,void,glRects,(GLshort x1, GLshort y1, GLshort x2, GLshort y2))
GL_PROC(_GL,void,glRectsv,(const GLshort *v1, const GLshort *v2))
GL_PROC(_GL,GLint,glRenderMode,(GLenum mode))
GL_PROC(_GL,void,glRotated,(GLdouble angle, GLdouble x, GLdouble y, GLdouble z))
GL_PROC(_GL,void,glRotatef,(GLfloat angle, GLfloat x, GLfloat y, GLfloat z))
GL_PROC(_GL,void,glScaled,(GLdouble x, GLdouble y, GLdouble z))
GL_PROC(_GL,void,glScalef,(GLfloat x, GLfloat y, GLfloat z))
GL_PROC(_GL,void,glScissor,(GLint x, GLint y, GLsizei width, GLsizei height))
GL_PROC(_GL,void,glSelectBuffer,(GLsizei size, GLuint *buffer))
GL_PROC(_GL,void,glShadeModel,(GLenum mode))
GL_PROC(_GL,void,glStencilFunc,(GLenum func, GLint ref, GLuint mask))
GL_PROC(_GL,void,glStencilMask,(GLuint mask))
GL_PROC(_GL,void,glStencilOp,(GLenum fail, GLenum zfail, GLenum zpass))
GL_PROC(_GL,void,glTexCoord1d,(GLdouble s))
GL_PROC(_GL,void,glTexCoord1dv,(const GLdouble *v))
GL_PROC(_GL,void,glTexCoord1f,(GLfloat s))
GL_PROC(_GL,void,glTexCoord1fv,(const GLfloat *v))
GL_PROC(_GL,void,glTexCoord1i,(GLint s))
GL_PROC(_GL,void,glTexCoord1iv,(const GLint *v))
GL_PROC(_GL,void,glTexCoord1s,(GLshort s))
GL_PROC(_GL,void,glTexCoord1sv,(const GLshort *v))
GL_PROC(_GL,void,glTexCoord2d,(GLdouble s, GLdouble t))
GL_PROC(_GL,void,glTexCoord2dv,(const GLdouble *v))
GL_PROC(_GL,void,glTexCoord2f,(GLfloat s, GLfloat t))
GL_PROC(_GL,void,glTexCoord2fv,(const GLfloat *v))
GL_PROC(_GL,void,glTexCoord2i,(GLint s, GLint t))
GL_PROC(_GL,void,glTexCoord2iv,(const GLint *v))
GL_PROC(_GL,void,glTexCoord2s,(GLshort s, GLshort t))
GL_PROC(_GL,void,glTexCoord2sv,(const GLshort *v))
GL_PROC(_GL,void,glTexCoord3d,(GLdouble s, GLdouble t, GLdouble r))
GL_PROC(_GL,void,glTexCoord3dv,(const GLdouble *v))
GL_PROC(_GL,void,glTexCoord3f,(GLfloat s, GLfloat t, GLfloat r))
GL_PROC(_GL,void,glTexCoord3fv,(const GLfloat *v))
GL_PROC(_GL,void,glTexCoord3i,(GLint s, GLint t, GLint r))
GL_PROC(_GL,void,glTexCoord3iv,(const GLint *v))
GL_PROC(_GL,void,glTexCoord3s,(GLshort s, GLshort t, GLshort r))
GL_PROC(_GL,void,glTexCoord3sv,(const GLshort *v))
GL_PROC(_GL,void,glTexCoord4d,(GLdouble s, GLdouble t, GLdouble r, GLdouble q))
GL_PROC(_GL,void,glTexCoord4dv,(const GLdouble *v))
GL_PROC(_GL,void,glTexCoord4f,(GLfloat s, GLfloat t, GLfloat r, GLfloat q))
GL_PROC(_GL,void,glTexCoord4fv,(const GLfloat *v))
GL_PROC(_GL,void,glTexCoord4i,(GLint s, GLint t, GLint r, GLint q))
GL_PROC(_GL,void,glTexCoord4iv,(const GLint *v))
GL_PROC(_GL,void,glTexCoord4s,(GLshort s, GLshort t, GLshort r, GLshort q))
GL_PROC(_GL,void,glTexCoord4sv,(const GLshort *v))
GL_PROC(_GL,void,glTexCoordPointer,(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer))
GL_PROC(_GL,void,glTexEnvf,(GLenum target, GLenum pname, GLfloat param))
GL_PROC(_GL,void,glTexEnvfv,(GLenum target, GLenum pname, const GLfloat *params))
GL_PROC(_GL,void,glTexEnvi,(GLenum target, GLenum pname, GLint param))
GL_PROC(_GL,void,glTexEnviv,(GLenum target, GLenum pname, const GLint *params))
GL_PROC(_GL,void,glTexGend,(GLenum coord, GLenum pname, GLdouble param))
GL_PROC(_GL,void,glTexGendv,(GLenum coord, GLenum pname, const GLdouble *params))
GL_PROC(_GL,void,glTexGenf,(GLenum coord, GLenum pname, GLfloat param))
GL_PROC(_GL,void,glTexGenfv,(GLenum coord, GLenum pname, const GLfloat *params))
GL_PROC(_GL,void,glTexGeni,(GLenum coord, GLenum pname, GLint param))
GL_PROC(_GL,void,glTexGeniv,(GLenum coord, GLenum pname, const GLint *params))
GL_PROC(_GL,void,glTexImage1D,(GLenum target, GLint level, GLint internalformat, GLsizei width, GLint border, GLenum format, GLenum type, const GLvoid *pixels))
GL_PROC(_GL,void,glTexImage2D,(GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const GLvoid *pixels))
GL_PROC(_GL,void,glTexParameterf,(GLenum target, GLenum pname, GLfloat param))
GL_PROC(_GL,void,glTexParameterfv,(GLenum target, GLenum pname, const GLfloat *params))
GL_PROC(_GL,void,glTexParameteri,(GLenum target, GLenum pname, GLint param))
GL_PROC(_GL,void,glTexParameteriv,(GLenum target, GLenum pname, const GLint *params))
GL_PROC(_GL,void,glTexSubImage1D,(GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const GLvoid *pixels))
GL_PROC(_GL,void,glTexSubImage2D,(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels))
GL_PROC(_GL,void,glTranslated,(GLdouble x, GLdouble y, GLdouble z))
GL_PROC(_GL,void,glTranslatef,(GLfloat x, GLfloat y, GLfloat z))
GL_PROC(_GL,void,glVertex2d,(GLdouble x, GLdouble y))
GL_PROC(_GL,void,glVertex2dv,(const GLdouble *v))
GL_PROC(_GL,void,glVertex2f,(GLfloat x, GLfloat y))
GL_PROC(_GL,void,glVertex2fv,(const GLfloat *v))
GL_PROC(_GL,void,glVertex2i,(GLint x, GLint y))
GL_PROC(_GL,void,glVertex2iv,(const GLint *v))
GL_PROC(_GL,void,glVertex2s,(GLshort x, GLshort y))
GL_PROC(_GL,void,glVertex2sv,(const GLshort *v))
GL_PROC(_GL,void,glVertex3d,(GLdouble x, GLdouble y, GLdouble z))
GL_PROC(_GL,void,glVertex3dv,(const GLdouble *v))
GL_PROC(_GL,void,glVertex3f,(GLfloat x, GLfloat y, GLfloat z))
GL_PROC(_GL,void,glVertex3fv,(const GLfloat *v))
GL_PROC(_GL,void,glVertex3i,(GLint x, GLint y, GLint z))
GL_PROC(_GL,void,glVertex3iv,(const GLint *v))
GL_PROC(_GL,void,glVertex3s,(GLshort x, GLshort y, GLshort z))
GL_PROC(_GL,void,glVertex3sv,(const GLshort *v))
GL_PROC(_GL,void,glVertex4d,(GLdouble x, GLdouble y, GLdouble z, GLdouble w))
GL_PROC(_GL,void,glVertex4dv,(const GLdouble *v))
GL_PROC(_GL,void,glVertex4f,(GLfloat x, GLfloat y, GLfloat z, GLfloat w))
GL_PROC(_GL,void,glVertex4fv,(const GLfloat *v))
GL_PROC(_GL,void,glVertex4i,(GLint x, GLint y, GLint z, GLint w))
GL_PROC(_GL,void,glVertex4iv,(const GLint *v))
GL_PROC(_GL,void,glVertex4s,(GLshort x, GLshort y, GLshort z, GLshort w))
GL_PROC(_GL,void,glVertex4sv,(const GLshort *v))
GL_PROC(_GL,void,glVertexPointer,(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer))
GL_PROC(_GL,void,glViewport,(GLint x, GLint y, GLsizei width, GLsizei height))

#ifdef WIN32
// WGL functions.
GL_PROC(_GL,BOOL,wglCopyContext,(HGLRC,HGLRC,UINT))
GL_PROC(_GL,HGLRC,wglCreateContext,(HDC))
GL_PROC(_GL,HGLRC,wglCreateLayerContext,(HGLRC))
GL_PROC(_GL,BOOL,wglDeleteContext,(HGLRC))
GL_PROC(_GL,HGLRC,wglGetCurrentContext,(VOID))
GL_PROC(_GL,HDC,wglGetCurrentDC,(VOID))
GL_PROC(_GL,PROC,wglGetProcAddress,(LPCSTR))
GL_PROC(_GL,BOOL,wglMakeCurrent,(HDC, HGLRC))
GL_PROC(_GL,BOOL,wglShareLists,(HGLRC,HGLRC))

// GDI functions.
GL_PROC(_GL,INT,ChoosePixelFormat,(HDC hDC,CONST PIXELFORMATDESCRIPTOR*))
GL_PROC(_GL,INT,DescribePixelFormat,(HDC,INT,UINT,PIXELFORMATDESCRIPTOR*))
GL_PROC(_GL,BOOL,GetPixelFormat,(HDC))
GL_PROC(_GL,BOOL,SetPixelFormat,(HDC,INT,CONST PIXELFORMATDESCRIPTOR*))
GL_PROC(_GL,BOOL,SwapBuffers,(HDC hDC))
#endif


/*-----------------------------------------------------------------------------
	OpenGL extensions.
-----------------------------------------------------------------------------*/

// BGRA textures.
GL_EXT(_GL_EXT_bgra)

//!!vogel: wglGetProcAddress requires an active context -> hack
// OpenGL 1.2
GL_PROC(_GL_EXT_bgra,void,glDrawRangeElements,(GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const GLvoid *indices))

// Generic texture compression.
GL_EXT(_GL_ARB_texture_compression)
GL_PROC(_GL_ARB_texture_compression,void,glCompressedTexSubImage2DARB,(GLenum, GLint, GLint, GLint, GLsizei, GLsizei, GLenum, GLsizei, const GLvoid *))
GL_PROC(_GL_ARB_texture_compression,void,glCompressedTexImage2DARB,(GLenum, GLint, GLenum, GLsizei, GLsizei, GLint, GLsizei, const GLvoid *))

// DXTC.
GL_EXT(_GL_EXT_texture_compression_s3tc)

// Cubemaps.
GL_EXT(_GL_ARB_texture_cube_map)

// Roughly equivalent to DX7 blending.
GL_EXT(_GL_ARB_texture_env_combine)

// Missing DX7 blending functionality.
GL_EXT(_GL_NV_texture_env_combine4)
GL_EXT(_GL_ATIX_texture_env_combine3)
GL_EXT(_GL_ATI_texture_env_combine3)
GL_EXT(_GL_ARB_texture_env_crossbar)

// Part of OpenGL 1.4 but we only require 1.3.
GL_EXT(_GL_EXT_texture_lod_bias)

// ARB multitexture.
GL_EXT(_GL_ARB_multitexture)
GL_PROC(_GL_ARB_multitexture,void,glMultiTexCoord1fARB,(GLenum target,GLfloat))
GL_PROC(_GL_ARB_multitexture,void,glMultiTexCoord2fARB,(GLenum target,GLfloat,GLfloat))
GL_PROC(_GL_ARB_multitexture,void,glMultiTexCoord3fARB,(GLenum target,GLfloat,GLfloat,GLfloat))
GL_PROC(_GL_ARB_multitexture,void,glMultiTexCoord4fARB,(GLenum target,GLfloat,GLfloat,GLfloat,GLfloat))
GL_PROC(_GL_ARB_multitexture,void,glMultiTexCoord1fvARB,(GLenum target,GLfloat))
GL_PROC(_GL_ARB_multitexture,void,glMultiTexCoord2fvARB,(GLenum target,GLfloat,GLfloat))
GL_PROC(_GL_ARB_multitexture,void,glMultiTexCoord3fvARB,(GLenum target,GLfloat,GLfloat,GLfloat))
GL_PROC(_GL_ARB_multitexture,void,glMultiTexCoord4fvARB,(GLenum target,GLfloat,GLfloat,GLfloat,GLfloat))
GL_PROC(_GL_ARB_multitexture,void,glActiveTextureARB,(GLenum target))
GL_PROC(_GL_ARB_multitexture,void,glClientActiveTextureARB,(GLenum target))

// Resource handling.
GL_EXT(_GL_ATI_vertex_array_object)
GL_PROC(_GL_ATI_vertex_array_object,GLuint,glNewObjectBufferATI,(GLsizei size, const void *pointer, GLenum usage))
GL_PROC(_GL_ATI_vertex_array_object,GLboolean,glIsObjectBufferATI,(GLuint buffer))
GL_PROC(_GL_ATI_vertex_array_object,void,glUpdateObjectBufferATI,(GLuint buffer, GLuint offset, GLsizei size, const void *pointer, GLenum preserve))
GL_PROC(_GL_ATI_vertex_array_object,void,glGetObjectBufferfvATI,(GLuint buffer, GLenum pname, GLfloat *params))
GL_PROC(_GL_ATI_vertex_array_object,void,glGetObjectBufferivATI,(GLuint buffer, GLenum pname, GLint *params))
GL_PROC(_GL_ATI_vertex_array_object,void,glFreeObjectBufferATI,(GLuint buffer))
GL_PROC(_GL_ATI_vertex_array_object,void,glArrayObjectATI,(GLenum array, GLint size, GLenum type, GLsizei stride, GLuint buffer, GLuint offset))
GL_PROC(_GL_ATI_vertex_array_object,void,glGetArrayObjectfvATI,(GLenum array, GLenum pname, GLfloat *params))
GL_PROC(_GL_ATI_vertex_array_object,void,glGetArrayObjectivATI,(GLenum array, GLenum pname, GLint *params))

GL_EXT(_GL_ATI_element_array)
GL_PROC(_GL_ATI_element_array,void,glElementPointerATI,(GLenum type, const void *pointer))
GL_PROC(_GL_ATI_element_array,void,glDrawElementArrayATI,(GLenum mode, GLsizei count))
GL_PROC(_GL_ATI_element_array,void,glDrawRangeElementArrayATI,(GLenum mode, GLuint start, GLuint end, GLsizei count))

GL_EXT(_GL_ATI_map_object_buffer)
GL_PROC(_GL_ATI_map_object_buffer,void*,glMapObjectBufferATI,(GLuint buffer))
GL_PROC(_GL_ATI_map_object_buffer,void,glUnmapObjectBufferATI,(GLuint buffer))

GL_EXT(_GL_NV_vertex_array_range)
GL_PROC(_GL_NV_vertex_array_range,void,glFlushVertexArrayRangeNV,(void))
GL_PROC(_GL_NV_vertex_array_range,void,glVertexArrayRangeNV,(GLsizei, const GLvoid *))
#ifdef WIN32
GL_PROC(_GL_NV_vertex_array_range,void*,wglAllocateMemoryNV,(GLsizei, GLfloat, GLfloat, GLfloat))
GL_PROC(_GL_NV_vertex_array_range,void,wglFreeMemoryNV,(void *))
#else
GL_PROC(_GL_NV_vertex_array_range,void*,glXAllocateMemoryNV,(GLsizei, GLfloat, GLfloat, GLfloat))
GL_PROC(_GL_NV_vertex_array_range,void,glXFreeMemoryNV,(void *))
#endif

GL_EXT(_GL_NV_vertex_array_range2)

GL_EXT(_GL_APPLE_vertex_array_range)
GL_PROC(_GL_APPLE_vertex_array_range,void,glVertexArrayRangeAPPLE,(GLsizei, const GLvoid *))
GL_PROC(_GL_APPLE_vertex_array_range,void,glFlushVertexArrayRangeAPPLE,(GLsizei, const GLvoid *))
GL_PROC(_GL_APPLE_vertex_array_range,void,glVertexArrayParameteriAPPLE,(GLenum, GLint))

GL_EXT(_GL_APPLE_vertex_array_object)
GL_PROC(_GL_APPLE_vertex_array_range,void,glBindVertexArrayAPPLE,(GLuint))
GL_PROC(_GL_APPLE_vertex_array_range,void,glDeleteVertexArraysAPPLE,(GLsizei, const GLuint *))
GL_PROC(_GL_APPLE_vertex_array_range,void,glGenVertexArraysAPPLE,(GLsizei, const GLuint *))
GL_PROC(_GL_APPLE_vertex_array_range,GLboolean,glIsVertexArrayAPPLE,(GLuint))

GL_EXT(_GL_ATI_array_rev_comps_in_4_bytes)

// FIXME: remove this?
#ifndef GL_ARRAY_REV_COMPS_IN_4_BYTES_ATI
#define GL_ARRAY_REV_COMPS_IN_4_BYTES_ATI 0x897C
#endif

// FSAA stuff. --ryan.
GL_EXT(_GL_ARB_multisample)
GL_PROC(_GL_ARB_multisample,void,glSampleCoverageARB,(GLclampf, GLboolean))

GL_EXT(_GL_NV_multisample_filter_hint)

// Anisotropic filtering. --ryan.
GL_EXT(_GL_EXT_texture_filter_anisotropic)

// Drivers report as part of GL extension string even though it's a WGL extension.
GL_EXT(_WGL_EXT_swap_control)
GL_PROC(_WGL_EXT_swap_control,GLboolean,wglSwapIntervalEXT,(GLint))
GL_PROC(_WGL_EXT_swap_control,GLint,wglGetSwapIntervalEXT,(void))

GL_EXT(_GL_ARB_vertex_buffer_object);
GL_PROC(_GL_ARB_vertex_buffer_object,void,glBindBufferARB,(GLenum,GLuint));
GL_PROC(_GL_ARB_vertex_buffer_object,void,glDeleteBuffersARB,(GLsizei, const GLuint*));
GL_PROC(_GL_ARB_vertex_buffer_object,void,glGenBuffersARB,(GLsizei, GLuint*));
GL_PROC(_GL_ARB_vertex_buffer_object,GLboolean,glIsBufferARB,(GLuint));
GL_PROC(_GL_ARB_vertex_buffer_object,void,glBufferDataARB,(GLenum,GLsizeiptrARB,const void*,GLenum));
GL_PROC(_GL_ARB_vertex_buffer_object,void,glBufferSubDataARB,(GLenum,GLintptrARB,GLsizeiptrARB,const void*));
GL_PROC(_GL_ARB_vertex_buffer_object,void,glGetBufferSubDataARB,(GLenum,GLintptrARB,GLsizeiptrARB,void*));
GL_PROC(_GL_ARB_vertex_buffer_object,void*,glMapBufferARB,(GLenum,GLenum));
GL_PROC(_GL_ARB_vertex_buffer_object,GLboolean,glUnmapBufferARB,(GLenum target));
GL_PROC(_GL_ARB_vertex_buffer_object,void,glGetBufferParameterivARB,(GLenum,GLenum,GLint*));
GL_PROC(_GL_ARB_vertex_buffer_object,void,glGetBufferPointervARB,(GLenum,GLenum,void**));

GL_EXT(_GL_ARB_fragment_program)
GL_PROC(_GL_ARB_fragment_program,void,glVertexAttrib1dARB,(GLuint, GLdouble))
GL_PROC(_GL_ARB_fragment_program,void,glVertexAttrib1dvARB,(GLuint, const GLdouble *))
GL_PROC(_GL_ARB_fragment_program,void,glVertexAttrib1fARB,(GLuint, GLfloat))
GL_PROC(_GL_ARB_fragment_program,void,glVertexAttrib1fvARB,(GLuint, const GLfloat *))
GL_PROC(_GL_ARB_fragment_program,void,glVertexAttrib1sARB,(GLuint, GLshort))
GL_PROC(_GL_ARB_fragment_program,void,glVertexAttrib1svARB,(GLuint, const GLshort *))
GL_PROC(_GL_ARB_fragment_program,void,glVertexAttrib2dARB,(GLuint, GLdouble, GLdouble))
GL_PROC(_GL_ARB_fragment_program,void,glVertexAttrib2dvARB,(GLuint, const GLdouble *))
GL_PROC(_GL_ARB_fragment_program,void,glVertexAttrib2fARB,(GLuint, GLfloat, GLfloat))
GL_PROC(_GL_ARB_fragment_program,void,glVertexAttrib2fvARB,(GLuint, const GLfloat *))
GL_PROC(_GL_ARB_fragment_program,void,glVertexAttrib2sARB,(GLuint, GLshort, GLshort))
GL_PROC(_GL_ARB_fragment_program,void,glVertexAttrib2svARB,(GLuint, const GLshort *))
GL_PROC(_GL_ARB_fragment_program,void,glVertexAttrib3dARB,(GLuint, GLdouble, GLdouble, GLdouble))
GL_PROC(_GL_ARB_fragment_program,void,glVertexAttrib3dvARB,(GLuint, const GLdouble *))
GL_PROC(_GL_ARB_fragment_program,void,glVertexAttrib3fARB,(GLuint, GLfloat, GLfloat, GLfloat))
GL_PROC(_GL_ARB_fragment_program,void,glVertexAttrib3fvARB,(GLuint, const GLfloat *))
GL_PROC(_GL_ARB_fragment_program,void,glVertexAttrib3sARB,(GLuint, GLshort, GLshort, GLshort))
GL_PROC(_GL_ARB_fragment_program,void,glVertexAttrib3svARB,(GLuint, const GLshort *))
GL_PROC(_GL_ARB_fragment_program,void,glVertexAttrib4NbvARB,(GLuint, const GLbyte *))
GL_PROC(_GL_ARB_fragment_program,void,glVertexAttrib4NivARB,(GLuint, const GLint *))
GL_PROC(_GL_ARB_fragment_program,void,glVertexAttrib4NsvARB,(GLuint, const GLshort *))
GL_PROC(_GL_ARB_fragment_program,void,glVertexAttrib4NubARB,(GLuint, GLubyte, GLubyte, GLubyte, GLubyte))
GL_PROC(_GL_ARB_fragment_program,void,glVertexAttrib4NubvARB,(GLuint, const GLubyte *))
GL_PROC(_GL_ARB_fragment_program,void,glVertexAttrib4NuivARB,(GLuint, const GLuint *))
GL_PROC(_GL_ARB_fragment_program,void,glVertexAttrib4NusvARB,(GLuint, const GLushort *))
GL_PROC(_GL_ARB_fragment_program,void,glVertexAttrib4bvARB,(GLuint, const GLbyte *))
GL_PROC(_GL_ARB_fragment_program,void,glVertexAttrib4dARB,(GLuint, GLdouble, GLdouble, GLdouble, GLdouble))
GL_PROC(_GL_ARB_fragment_program,void,glVertexAttrib4dvARB,(GLuint, const GLdouble *))
GL_PROC(_GL_ARB_fragment_program,void,glVertexAttrib4fARB,(GLuint, GLfloat, GLfloat, GLfloat, GLfloat))
GL_PROC(_GL_ARB_fragment_program,void,glVertexAttrib4fvARB,(GLuint, const GLfloat *))
GL_PROC(_GL_ARB_fragment_program,void,glVertexAttrib4ivARB,(GLuint, const GLint *))
GL_PROC(_GL_ARB_fragment_program,void,glVertexAttrib4sARB,(GLuint, GLshort, GLshort, GLshort, GLshort))
GL_PROC(_GL_ARB_fragment_program,void,glVertexAttrib4svARB,(GLuint, const GLshort *))
GL_PROC(_GL_ARB_fragment_program,void,glVertexAttrib4ubvARB,(GLuint, const GLubyte *))
GL_PROC(_GL_ARB_fragment_program,void,glVertexAttrib4uivARB,(GLuint, const GLuint *))
GL_PROC(_GL_ARB_fragment_program,void,glVertexAttrib4usvARB,(GLuint, const GLushort *))
GL_PROC(_GL_ARB_fragment_program,void,glVertexAttribPointerARB,(GLuint, GLint, GLenum, GLboolean, GLsizei, const GLvoid *))
GL_PROC(_GL_ARB_fragment_program,void,glEnableVertexAttribArrayARB,(GLuint))
GL_PROC(_GL_ARB_fragment_program,void,glDisableVertexAttribArrayARB,(GLuint))
GL_PROC(_GL_ARB_fragment_program,void,glProgramStringARB,(GLenum, GLenum, GLsizei, const GLvoid *))
GL_PROC(_GL_ARB_fragment_program,void,glBindProgramARB,(GLenum, GLuint))
GL_PROC(_GL_ARB_fragment_program,void,glDeleteProgramsARB,(GLsizei, const GLuint *))
GL_PROC(_GL_ARB_fragment_program,void,glGenProgramsARB,(GLsizei, GLuint *))
GL_PROC(_GL_ARB_fragment_program,void,glProgramEnvParameter4dARB,(GLenum, GLuint, GLdouble, GLdouble, GLdouble, GLdouble))
GL_PROC(_GL_ARB_fragment_program,void,glProgramEnvParameter4dvARB,(GLenum, GLuint, const GLdouble *))
GL_PROC(_GL_ARB_fragment_program,void,glProgramEnvParameter4fARB,(GLenum, GLuint, GLfloat, GLfloat, GLfloat, GLfloat))
GL_PROC(_GL_ARB_fragment_program,void,glProgramEnvParameter4fvARB,(GLenum, GLuint, const GLfloat *))
GL_PROC(_GL_ARB_fragment_program,void,glProgramLocalParameter4dARB,(GLenum, GLuint, GLdouble, GLdouble, GLdouble, GLdouble))
GL_PROC(_GL_ARB_fragment_program,void,glProgramLocalParameter4dvARB,(GLenum, GLuint, const GLdouble *))
GL_PROC(_GL_ARB_fragment_program,void,glProgramLocalParameter4fARB,(GLenum, GLuint, GLfloat, GLfloat, GLfloat, GLfloat))
GL_PROC(_GL_ARB_fragment_program,void,glProgramLocalParameter4fvARB,(GLenum, GLuint, const GLfloat *))
GL_PROC(_GL_ARB_fragment_program,void,glGetProgramEnvParameterdvARB,(GLenum, GLuint, GLdouble *))
GL_PROC(_GL_ARB_fragment_program,void,glGetProgramEnvParameterfvARB,(GLenum, GLuint, GLfloat *))
GL_PROC(_GL_ARB_fragment_program,void,glGetProgramLocalParameterdvARB,(GLenum, GLuint, GLdouble *))
GL_PROC(_GL_ARB_fragment_program,void,glGetProgramLocalParameterfvARB,(GLenum, GLuint, GLfloat *))
GL_PROC(_GL_ARB_fragment_program,void,glGetProgramivARB,(GLenum, GLenum, GLint *))
GL_PROC(_GL_ARB_fragment_program,void,glGetProgramStringARB,(GLenum, GLenum, GLvoid *))
GL_PROC(_GL_ARB_fragment_program,void,glGetVertexAttribdvARB,(GLuint, GLenum, GLdouble *))
GL_PROC(_GL_ARB_fragment_program,void,glGetVertexAttribfvARB,(GLuint, GLenum, GLfloat *))
GL_PROC(_GL_ARB_fragment_program,void,glGetVertexAttribivARB,(GLuint, GLenum, GLint *))
GL_PROC(_GL_ARB_fragment_program,void,glGetVertexAttribPointervARB,(GLuint, GLenum, GLvoid* *))
GL_PROC(_GL_ARB_fragment_program,GLboolean,glIsProgramARB,(GLuint))

GL_EXT(_GL_ARB_vertex_program)


// Render-to-texture. --ryan.
GL_EXT(_GL_EXT_framebuffer_object)
GL_PROC(_GL_EXT_framebuffer_object,GLboolean,glIsRenderbufferEXT,(GLuint))
GL_PROC(_GL_EXT_framebuffer_object,void,glBindRenderbufferEXT,(GLenum, GLuint))
GL_PROC(_GL_EXT_framebuffer_object,void,glDeleteRenderbuffersEXT,(GLsizei, const GLuint *))
GL_PROC(_GL_EXT_framebuffer_object,void,glGenRenderbuffersEXT,(GLsizei, GLuint *))
GL_PROC(_GL_EXT_framebuffer_object,void,glRenderbufferStorageEXT,(GLenum, GLenum, GLsizei, GLsizei))
GL_PROC(_GL_EXT_framebuffer_object,void,glGetRenderbufferParameterivEXT,(GLenum, GLenum, GLint*))
GL_PROC(_GL_EXT_framebuffer_object,GLboolean,glIsFramebufferEXT,(GLuint))
GL_PROC(_GL_EXT_framebuffer_object,void,glBindFramebufferEXT,(GLenum, GLuint))
GL_PROC(_GL_EXT_framebuffer_object,void,glDeleteFramebuffersEXT,(GLsizei, const GLuint *))
GL_PROC(_GL_EXT_framebuffer_object,void,glGenFramebuffersEXT,(GLsizei, GLuint *))
GL_PROC(_GL_EXT_framebuffer_object,GLenum,glCheckFramebufferStatusEXT,(GLenum))
GL_PROC(_GL_EXT_framebuffer_object,void,glFramebufferTexture1DEXT,(GLenum, GLenum, GLenum, GLuint, GLint))
GL_PROC(_GL_EXT_framebuffer_object,void,glFramebufferTexture2DEXT,(GLenum, GLenum, GLenum, GLuint, GLint))
GL_PROC(_GL_EXT_framebuffer_object,void,glFramebufferTexture3DEXT,(GLenum, GLenum, GLenum, GLuint, GLint, GLint))
GL_PROC(_GL_EXT_framebuffer_object,void,glFramebufferRenderbufferEXT,(GLenum, GLenum, GLenum, GLuint))
GL_PROC(_GL_EXT_framebuffer_object,void,glGetFramebufferAttachmentParameterivEXT,(GLenum, GLenum, GLenum, GLint *))
GL_PROC(_GL_EXT_framebuffer_object,void,glGenerateMipmapEXT,(GLenum))

// non-power-of-two texture support...needed by some mods for render-to-texture stuff.  --ryan.
GL_EXT(_GL_ARB_texture_non_power_of_two)

/*-----------------------------------------------------------------------------
	The End.
-----------------------------------------------------------------------------*/

